﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class DailySalesReportBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DailySalesReport GetItem(Guid ReportID, DateTime ReportDate)
        {
            return DailySalesReportDB.GetItem(ReportID,ReportDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<DailySalesReport> GetList(Guid ReportID, DateTime ReportDate)
        {
            return DailySalesReportDB.GetList(ReportID, ReportDate);
        }

       
        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(DailySalesReport SalesReport)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                DailySalesReportDB.Save(SalesReport);
                myTransactionScope.Complete();
                return true;
            }
        }

        //public static bool Delete(Guid TableID)
        //{
        //    using (TransactionScope myTransactionScope = new TransactionScope())
        //    {
        //        LayoutsDB.Delete(TableID);

        //        myTransactionScope.Complete();
        //        return true;
        //    }
        //}

    }
}
